class goWarShell21 extends Projectile;

#exec mesh import mesh=deemah1 anivfile=Models\deemah1_a.3d datafile=Models\deemah1_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=deemah1 x=0 y=0 z=0
#exec mesh sequence mesh=deemah1 seq=All startframe=0 numframes=1

#exec meshmap new meshmap=deemah1 mesh=deemah1
#exec meshmap scale meshmap=deemah1 x=0.08607 y=0.08607 z=0.17214

#exec TEXTURE IMPORT NAME=RDMR_Missile FILE=Textures\MissileSkin.pcx GROUP=Skins
#exec AUDIO IMPORT FILE="SOUNDS\thecrash.wav" NAME="thecrash" GROUP=Redeemer


var float CannonTimer, SmokeRate;
var redeemertrail trail;

simulated function Timer()
{
    local goUT_SpriteSmokePuff b;

    if ( Trail == None )
        Trail = Spawn(class'RedeemerTrail',self);

    CannonTimer += SmokeRate;
    if ( CannonTimer > 0.6 )
    {
        WarnCannons();
        CannonTimer -= 0.6;
    }

    if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
    {
        SetTimer(SmokeRate, false);
        Return;
    }

    if ( Level.bHighDetailMode )
    {
        if ( Level.bDropDetail )
            Spawn(class'LightSmokeTrail');
        else
            Spawn(class'goUTSmokeTrail');
        SmokeRate = 152/Speed; 
    }
    else 
    {
        SmokeRate = 0.15;
        b = Spawn(class'goUT_SpriteSmokePuff');
        b.RemoteRole = ROLE_None;
    }
    SetTimer(SmokeRate, false);
}

simulated function Destroyed()
{
    if ( Trail != None )
        Trail.Destroy();
    Super.Destroyed();
}

simulated function PostBeginPlay()
{
    SmokeRate = 0.3;
    SetTimer(0.3,false); 
}

function WarnCannons()
{
    local Pawn P;

    for ( P=Level.Pawnlist; P!=None; P=P.NextPawn )
        if ( P.IsA('TeamCannon') && !P.IsInState('TrackWarhead') && P.LineOfSightTo(self) )
        {
            P.target = self;
            P.GotoState('TrackWarhead');
        }
}

singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, vector momentum, name damageType )
{
    if ( NDamage > 5 )
    {
        PlaySound(Sound'goblast',,6.0);
        spawn(class'goWarExplosion',,,Location);
        HurtRadius(Damage,350.0, MyDamageType, MomentumTransfer, HitLocation );
        RemoteRole = ROLE_SimulatedProxy;                   
        Destroy();
    }
}

auto state Flying
{
    simulated function ZoneChange( Zoneinfo NewZone )
    {
        local waterring w;
        
        if ( NewZone.bWaterZone != Region.Zone.bWaterZone )
        {
            w = Spawn(class'WaterRing',,,,rot(16384,0,0));
            w.DrawScale = 0.2;
            w.RemoteRole = ROLE_None; 
        }   
    }

    function ProcessTouch (Actor Other, Vector HitLocation)
    {
        if ( Other != instigator ) 
            Explode(HitLocation,Normal(HitLocation-Other.Location));
    }

    function Explode(vector HitLocation, vector HitNormal)
    {
        if ( Role < ROLE_Authority )
            return;

        Spawn(class'SpriteSmokePuff',,,HitLocation + HitNormal*16);
        PlaySound(Sound'thecrash');
        Spawn(class'GoFragment',,,HitLocation + HitNormal*16);
        RemoteRole = ROLE_SimulatedProxy;
        Destroy();
    }

    function BeginState()
    {
        local vector InitialDir;

        initialDir = vector(Rotation);
        if ( Role == ROLE_Authority )   
            Velocity = speed*initialDir;
        Acceleration = initialDir*50;
    }
}

simulated function HitWall (vector HitNormal, actor Wall)
{
    if ( Role == ROLE_Authority )
    {
        if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
            Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), '');

        MakeNoise(1.0);
    }
    Explode(Location + ExploWallOut * HitNormal, HitNormal);
    if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )
       Spawn(ExplosionDecal,self,,Location, rotator(HitNormal));
       ExplosionDecal = None;
}

defaultproperties
{
     ExplosionDecal=class'RidiculousDeemer.goNuclearMarkdeemerbump'
     DrawScale=1.800000
     speed=600.000000
     Damage=200.000000
     MomentumTransfer=10000
     MyDamageType=RedeemerDeath
     bNetTemporary=False
     RemoteRole=ROLE_SimulatedProxy
     Mesh=Mesh'deemah1'
     MultiSkins=Texture'RDMR_Missile'
     AmbientGlow=78
     bUnlit=True
     SoundRadius=100
     SoundVolume=255
     AmbientSound=Sound'Botpack.Redeemer.WarFly'
     CollisionRadius=15.000000
     CollisionHeight=8.000000
     bProjTarget=True
     bFixedRotationDir=True
     RotationRate=(Pitch=0,Yaw=0,Roll=30000),
}